function createAlignFile()
    clc;
    clear all;
    warning off;
    rootDir=pwd;
    alignDir = strcat(rootDir,'/alignFileClustal/');
    %alignDir = strcat(rootDir,'/C-alignFileClustal/'); %Complement
    %alignDir = strcat(rootDir,'/RC-alignFileClustal/'); %Reverse Complement
    refFastaDir = strcat(rootDir,'/refFasta/');
    %refFastaDir = strcat(rootDir,'/refFastaComplement/'); %Complement
    %refFastaDir = strcat(rootDir,'/refFastaRComplement/'); %Reverse Complement
    mkdir(alignDir);
    %iHuman = 'human-mature-miRNA.fasta';
    %iHuman = 'human-mature-miRNA-Complement-with-T.fasta'; %Complement
    %iHuman = 'human-mature-miRNA-R-Complement-with-T.fasta'; % Reverse Complement
    fastaDtl_2 = fastaread(iHuman);
    
    for i = 1:size(fastaDtl_2,1)        
        data(2).Sequence=fastaDtl_2(i).Sequence;
        data(2).Header = fastaDtl_2(i).Header;
        
        a = split(fastaDtl_2(i).Header);
        iRef = strcat(refFastaDir,convertStringsToChars(string(a(1))),'.fasta');
        %iRef = strcat(refFastaDir,convertStringsToChars(string(a(1))),'-Complement.fasta'); %Complement
        %iRef = strcat(refFastaDir,convertStringsToChars(string(a(1))),'-RComplement.fasta'); %Reverse Complement
        oFile = strcat(alignDir,convertStringsToChars(string(a(1))),'-align.fasta');
        %oFile = strcat(alignDir,convertStringsToChars(string(a(1))),'-Complement-align.fasta'); %Complement
        %oFile = strcat(alignDir,convertStringsToChars(string(a(1))),'-RComplement-align.fasta'); %Reverse Complement
        %command = strcat(rootDir,'\usr\bin\mafft --ep --auto --inputorder '," ", iRef,' > ',oFile)
        command = strcat(rootDir,'\clustalo -i'," ", iRef," ", '-o'," ", oFile, " ", '--outfmt=fasta --output-order=input-order --force');
        %mafft.bat --out output.txt --auto input.txt
        status = system(command);
        
    end
end