function createFasta4COVID()
    clc;
    clear all;
    warning off;
    plotDir=pwd;
    refFastaDir = strcat(plotDir,'/refFasta/');
    mkdir(refFastaDir);
    iVirus = 'virus-ref-with-T.fasta';
    iHuman = 'human-mature-miRNA.fasta';
    %iHuman = 'human-mature-miRNA-Complement-with-T.fasta'; %Complement
    %iHuman = 'human-mature-miRNA-R-Complement-with-T.fasta'; % Reverse Complement
    fastaDtl_1 = fastaread(iVirus);
    fastaDtl_2 = fastaread(iHuman);
    
    data(1).Sequence=fastaDtl_1.Sequence;
    data(1).Header = fastaDtl_1.Header;
    
    for i = 1:size(fastaDtl_2,1)        
        data(2).Sequence=fastaDtl_2(i).Sequence;
        data(2).Header = fastaDtl_2(i).Header;
        
        a = split(fastaDtl_2(i).Header);
        oFile = strcat(refFastaDir,convertStringsToChars(string(a(1))),'.fasta');
        %oFile = strcat(refFastaDir,convertStringsToChars(string(a(1))),'-Complement.fasta'); %Complement
        %oFile = strcat(refFastaDir,convertStringsToChars(string(a(1))),'-RComplement.fasta'); %Reverse Complement
        fastawrite(oFile, data);
    end
    
    
    
    

end