function generateSeqScore()
    clc;
    clear all;
    warning off;
    rootDir=pwd;
    alignDir = strcat(rootDir,'/alignFileClustal/');
    %alignDir = strcat(rootDir,'/C-alignFileClustal/'); %Complement
    %alignDir = strcat(rootDir,'/RC-alignFileClustal/'); %Reverse Complement
    

    iHuman = 'human-mature-miRNA.fasta';
    %iHuman = 'human-mature-miRNA-Complement-with-T.fasta'; %Complement
    %iHuman = 'human-mature-miRNA-R-Complement-with-T.fasta'; % Reverse Complement
    fastaDtl_2 = fastaread(iHuman);
    miRNA = {};
    alignVirusGe = {};
    
    for i = 1:size(fastaDtl_2,1)        
        data(2).Sequence=fastaDtl_2(i).Sequence;
        data(2).Header = fastaDtl_2(i).Header;
        
        miRNALength = length(fastaDtl_2(i).Sequence);
        a = split(fastaDtl_2(i).Header);
        miRNA = [miRNA;convertStringsToChars(string(a(1)))]
        iFile = strcat(alignDir,convertStringsToChars(string(a(1))),'-align.fasta');
        %iFile = strcat(alignDir,convertStringsToChars(string(a(1))),'-Complement-align.fasta'); %Complement
        %iFile = strcat(alignDir,convertStringsToChars(string(a(1))),'-RComplement-align.fasta'); % Reverse Complement
        [score(i), m(i), n(i), c(i), g(i),TL(i), N(i),startCor(i),endCor(i), ag] = JPSalignmentscore(iFile,miRNALength);
        alignVirusGe = [alignVirusGe;ag];
    end
    data = [m' n' c' g' TL' N' startCor' endCor' score'];
    file_header = {'miRNA','aligned_virus_genome','Num_Match', 'tol_mismatch', 'Max_Consecutive', 'Num_Gaps','Human_miRNA_Len','Expanded_len_after_align','Start_cordinate','End_cordinate', 'Score'};
    oFile = 'clustalo-alignment-score.xlsx';
    %oFile = 'clustalo-alignment-score-complement.xlsx'; %Complement
    %oFile = 'clustalo-alignment-score-R-complement.xlsx'; %Reverse Complement
    oSheet = 'score';
    xlswrite(oFile,file_header,oSheet,'A1');
    xlswrite(oFile,miRNA,oSheet,'A2');
    xlswrite(oFile,alignVirusGe,oSheet,'B2');
    xlswrite(oFile,data,oSheet,'C2');     %Write data
end