import pandas as pd 
import numpy as np 
from pandas import ExcelWriter

labels = {
    1: "LA",
    2: "LB",
    3: "H2",
    4: "BL"
}

methods = {
    1: "jmi",
    2: "mim",
    3: "mifs",
    4: "mrmr",
    5: "cmim",
    6: "disr",
    7: "cife",
    8: "icap",
    9: "condred"
}
final_file = "Results/4_star_ranks.xlsx"
writer = ExcelWriter(final_file)  

for label in labels:
    print('{}'.format(labels[label]))
    expression_file = "4star_{}.xlsx".format(labels[label])
    expression_df = pd.read_excel(expression_file, header=0)
    expression_df = expression_df.drop('Gene', 1)
    expression_df = expression_df.drop('PAM50 mRNA', 1)
    print(expression_df.shape)
    all_columns = (expression_df.columns.values)
    print('No. of genes: {}'.format(len(all_columns)))
    genes = []
    columns = ['Genes'] + list(methods.values())
    # method_df = pd.DataFrame(columns=['Genes', 'jmi', 'mim', 'mifs', 'mrmr'])
    method_df = pd.DataFrame(columns=columns)
    method_df['Genes'] = all_columns
    for method in methods:
        current_file = "Results/{}_{}.csv".format(labels[label], methods[method])
        current_df = pd.read_csv(current_file, header=None, index_col=None)
        print(current_file, current_df.shape)
        current_columns = current_df[0].values.tolist()
        method_df[methods[method]] = current_columns
    print('No. of ranks: {}'.format(len(current_columns)))
    method_df.to_excel(writer, '{}'.format(labels[label]), index=False)
writer.save()
