import pandas as pd 
import numpy as np 
from pandas import ExcelWriter

labels = {
    1: "LA",
    2: "LB",
    3: "H2",
    4: "BL"
}

methods = {
    1: "jmi",
    2: "mim",
    3: "mifs",
    4: "mrmr",
    5: "cmim",
    6: "disr",
    7: "cife",
    8: "icap",
    9: "condred",
    10: "cmi"
}
final_file = "Results/4_star_star.xlsx"
writer = ExcelWriter(final_file)  

rank_file = "Results/4_star_ranks.xlsx"
rank_df = pd.read_excel(rank_file, 'LA', header=0, index_col=0)
genes = rank_df.index.values.tolist()
method_df = pd.DataFrame(columns=['Genes'])

for label in labels:
    rank_df = pd.read_excel(rank_file, labels[label], header=0, index_col=0)
    current_genes = rank_df.index.values.tolist()
    genes = list(set(current_genes) & set(genes))
    print('Size: {}'.format(len(genes)))

method_df['Genes'] = genes 

for label in labels:
    common_df = pd.read_excel(rank_file, labels[label], header=0)
    common_df = common_df[common_df['Genes'].isin(genes)]
    current_df = common_df[['Genes', 'Average Weighted Ensemble']]
    current_columns = current_df['Average Weighted Ensemble'].values.tolist()
    method_df[labels[label]] = current_columns

# print('No. of ranks: {}'.format(len(current_columns)))
method_df.to_excel(writer, 'Sheet1', index=False)
writer.save()
