clc;
clear all;
file_type = 'TU'
file = strcat('../data/tumor/',file_type, 'andControl.xlsx')
[miRNA_all,str1] = xlsread(file); 

[n d]=size(miRNA_all);
points=miRNA_all(:,1:d-1);
tcl=miRNA_all(:,d);
normal_ln=length(find(tcl==2));
tumor_ln=(n-normal_ln);
normal_all=miRNA_all(tumor_ln+1:n,1:d-1);
tumor_all=miRNA_all(1:tumor_ln,1:d-1);

[pvalues, tscores] = mattest(normal_all', tumor_all',...
'Showhist', true', 'Showplot', true); 
pvaluesBH = mafdr(pvalues, 'BHFDR', true);
[pFDR, qValues] = mafdr(pvalues, 'showplot', true);

diffStruct = mavolcanoplot(normal_all', tumor_all', pvalues)                                
nDiffGenes = numel(diffStruct.GeneLabels) 
up_geneidx = find(diffStruct.FoldChanges > 0);
nUpGenes = length(up_geneidx) 
down_geneidx = find(diffStruct.FoldChanges < 0);
nDownGenes = length(down_geneidx)

file = strcat('down_geneidx_', file_type, '.csv')
down_geneidx = cell2mat(downstruct.GeneLabels)
csvwrite(file,down_geneidx)

file = strcat('up_geneidx_', file_type, '.csv')
up_geneidx = cell2mat(upstruct.GeneLabels)
csvwrite(file,up_geneidx)