import pandas as pd 
import numpy as np 
from pandas import ExcelWriter

categories = ['age', 'stage', 'tumor', 'hist', 'status']
final_file = "../Results/ranks.xlsx"

mirnas = []
for category in categories:
    df = pd.read_excel(final_file, sheet_name=category, header=0, index_col=0)
    names = df.index.tolist()
    mirnas.append(names[:100])

common = mirnas[0]
for mirna in mirnas:
    common = np.intersect1d(common, mirna)

print(common)
