import pandas as pd 
import numpy as np 
from pandas import ExcelWriter

genes = [line.rstrip('\n') for line in open('../data/list/adaptive/tumor.txt')]
df = pd.read_excel("../data/STAD_survival_data.xlsx", header=0, index_col=0)
df = df[np.intersect1d(df.columns, genes)]
df = df.applymap(lambda x: np.power(x, 2))
writer = ExcelWriter("../data/surv_denorm.xlsx")
df.to_excel(writer, "Denorm")
writer.save()