import pandas as pd 
import numpy as np 
from pandas import ExcelWriter

categories = {
    1: "common",
    2: "age",
    3: "tumor",
    4: "status",
    5: "stage",
    6: "histological"
}
trrust_df = pd.read_excel("../data/TRRUST_DB_Gene_TF.xlsx")
writer = ExcelWriter('../Results/TRRUST.xlsx')
    
for category in categories:
    genes_df = pd.read_excel("../Results/KEGG/adaptive/KEGG_{}.xlsx".format(categories[category]), header=0)
    print(trrust_df.shape, genes_df.shape)
    common_genes_df = trrust_df[trrust_df['Gene'].isin(genes_df['Gene'])]
    print(common_genes_df.head())
    common_genes_df.sort_values("Gene", inplace=True)
    common_genes_df.drop_duplicates("Gene", inplace=True)
    common_genes_df.to_excel(writer, categories[category], index=False)
writer.save()
