import pandas as pd 
import numpy as np 

subtypes = ['common', 'age', 'tumor', 'status', 'stage', 'histological']
for subtype in subtypes:
    gene_mirna_df = pd.read_csv("../Results/Network/Intersection/gene-mirna/{}.csv".format(subtype), header=0)
    mirna_tf_df = pd.read_csv("../Results/Network/Intersection/mirna-tf-overlap/{}.csv".format(subtype), header=0)
    # print(gene_mirna_df.head())
    # print(mirna_tf_df.head())

    merged_df = pd.merge(gene_mirna_df, mirna_tf_df, how='right', left_on = 'miRNA', right_on = 'miRNA (Mature)')
    merged_df = merged_df[['Gene', 'miRNA_x', 'TF']]
    print(len(merged_df['miRNA_x'].unique().tolist()))
    merged_df = merged_df.rename(columns={ merged_df.columns[1]: "miRNA" })
    merged_df = merged_df.drop_duplicates()
    print(merged_df.shape)
    
    merged_df.to_csv("../Results/Network/mirna-tf-gene/miRNATFGene_{}.csv".format(subtype), index=False) 