import pandas as pd 
labels = {
    # 1: "LA",
    # 2: "LB",
    # 3: "H2",
    2: "TU"
}

control_val = 1
label_title = 'label'
df = pd.read_csv("../data/R3/Level- 3/categorization_mRNA(RPKMlog2)/1. Tumour_Normal/STAD_mRNA_readcount_TN_level3.csv", header=0, index_col=0)
# df = pd.read_csv("/home/somnath/Documents/paper/NITTTR/34_miRNA/data/LAandControl.csv", header=0, index_col=0)
for label in labels:
    
    table_name = "../data/ismart_ready/STAD_mRNA_TUMOR_CONTROL_EXPRESSION.txt"
    noiseq_name = "../data/ismart_ready/STAD_mRNA_TUMOR_CONTROL_DESCRIPTION_NOISEQ.txt"
    deseq_name = "../data/ismart_ready/STAD_mRNA_TUMOR_CONTROL_DESCRIPTION_DESEQ_EDGER.txt"

    # Create and save table data
    table_df = df.loc[df[label_title].isin([label, control_val])]
    table_df.drop(['label'], axis=1).T.to_csv(table_name, sep='\t')

    # Create and save Noiseq data
    noiseq_columns = ['name', 'condition']
    noiseq_names = []
    noiseq_conditions = []
    noiseq_df = table_df.loc[table_df[label_title] == label]
    for i in range(noiseq_df[label_title].shape[0]):
        s = 'Sample_{}_test'.format(i+1)
        noiseq_names.append(s)
        noiseq_conditions.append('1_test')
    noiseq_df = table_df.loc[table_df[label_title] == control_val]
    for i in range(noiseq_df[label_title].shape[0]):
        s = 'Sample_{}_control'.format(i+1)
        noiseq_names.append(s)
        noiseq_conditions.append('2_control')
    noiseq_df = pd.DataFrame(columns=noiseq_columns)
    noiseq_df['name'] = noiseq_names
    noiseq_df['condition'] = noiseq_conditions
    noiseq_df.to_csv(noiseq_name, sep='\t', index=False)
    # print(noiseq_df['PAM50 mRNA'])
    
    # Create and save Deseq data
    deseq_columns = ['name', 'condition']
    deseq_names = []
    deseq_conditions = []
    deseq_df = table_df.loc[table_df[label_title] == label]
    for i in range(deseq_df[label_title].shape[0]):
        s = 'Sample_{}_test'.format(i+1)
        deseq_names.append(s)
        deseq_conditions.append('test')
    deseq_df = table_df.loc[table_df[label_title] == control_val]
    for i in range(deseq_df[label_title].shape[0]):
        s = 'Sample_{}_control'.format(i+1)
        deseq_names.append(s)
        deseq_conditions.append('control')
    deseq_df = pd.DataFrame(columns=deseq_columns)
    deseq_df['name'] = deseq_names
    deseq_df['condition'] = deseq_conditions
    deseq_df.to_csv(deseq_name, sep='\t', index=False)
 