import pandas as pd 
import numpy as np
import sys 

labels = {
    # 1: "LA",
    # 2: "LB",
    # 3: "H2",
    2: "TU"
}
control_val = 1
label_title = 'label'

df = pd.read_csv("../data/tumor/STAD_miRseq_mature_readcount_TN_level3.csv", header=0, index_col=0)
df[[label_title]] = df[[label_title]].astype(int)
# df.to_csv("transposed_expression.csv")

for label in labels:
    print('Starting {}'.format(labels[label]))

    # Create and save table data
    table_df = df.loc[df[label_title].isin([label, control_val])]
    table_df.loc[:, label_title] = np.where(table_df.loc[:, label_title] == label, 1, 2)
    print(table_df.head())
    table_df.to_excel("../data/tumor/{}andControl.xlsx".format(labels[label]))
    table_df.to_csv("../data/tumor/{}andControl.csv".format(labels[label]))